///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _EVENTS_CPP
#define _EVENTS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0500

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "CSockSrvr.H"

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/Common.H"

#include "../Source/Routines.H"
#include "../Source/HandShake.H"
#include "../Source/Command.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when a client thread is started.
*/
void CSockSrvr::SubClass_Events::OnBeginClientThread(CSockSrvr *lpCSockSrvr, int iClient)
{
	CCI[iClient].bIsAuthenticated = false;
	CCI[iClient].bIsEncryptionInit = false;
	CCI[iClient].bWPIndexConnected = false;
	CCI[iClient].bWPCustomerConnected = false;
	CCI[iClient].bRequestInit = false;
	CCI[iClient].dwAuthStep = 0;
	CCI[iClient].dwCorruptInitRetry = 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when a client thread is being terminated.

	This function is called before any client variables are freed.
*/
void CSockSrvr::SubClass_Events::OnEndClientThread(CSockSrvr *lpCSockSrvr, int iClient)
{
	if(CCI[iClient].bWPIndexConnected)
	{
		CCI[iClient].cIndexSQL.Disconnect();
	}

	if(CCI[iClient].bWPCustomerConnected)
	{
		CCI[iClient].cCustSQL.Disconnect();
	}

	if(CCI[iClient].bIsEncryptionInit)
	{
		if(gbDebugMode)
		{
			WriteLogEx(lpCSockSrvr->icClientID[iClient], "Uninitializing Cryptography Set...", EVENT_NONE);
		}
		
		CCI[iClient].SC.DestroyCryptography();

		CCI[iClient].bIsEncryptionInit = false;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when a client is connected.

	Return true to accept the connection, else return false.	
*/
bool CSockSrvr::SubClass_Events::OnConnect(CSockSrvr *lpCSockSrvr, int iClient)
{
	//gdwTotalConnects++;
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when a client is accepted.

	Return true to accept the connection, else return false.	
*/
bool CSockSrvr::SubClass_Events::OnAccept(CSockSrvr *lpCSockSrvr, int iClient)
{
	lpCSockSrvr->bcRawDataMode[iClient] = !gbPacketMode;

	memset(&CCI[iClient].stConnectTime, 0, sizeof(CCI[iClient].stConnectTime));
	memset(&CCI[iClient].sIPAddress, 0, sizeof(CCI[iClient].sIPAddress));

	GetSystemTime(&CCI[iClient].stConnectTime);

	CCI[iClient].dwBytesSent = 0;
	CCI[iClient].dwBytesRecv = 0;

	gdwTotalConnects++;
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when a client is connected / accepted.

	Return true to accept the connection, else return false.	
*/
bool CSockSrvr::SubClass_Events::OnAcceptConnect(CSockSrvr *lpCSockSrvr, int iClient)
{
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when a client is being disconnected.

	This function is called before any client variables are freed.
*/
void CSockSrvr::SubClass_Events::OnDisconnect(CSockSrvr *lpCSockSrvr, int iClient)
{
	if(lpCSockSrvr->icClientID[iClient] >= 0)
	{
		WriteLogEx(lpCSockSrvr->icClientID[iClient], "Disconnected.", EVENT_NONE);
	}
	else WriteSysLogEx("Disconnected.", EVENT_NONE);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when data is being sent.

	Return true to send the data, else return false.	
*/

bool CSockSrvr::SubClass_Events::OnSend(CSockSrvr *lpCSockSrvr, int iClient, char *sData, int iSize)
{
	CCI[iClient].dwBytesSent += (DWORD)iSize;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when data is being received.

	Return true to receive the data, else return false.	
*/

bool CSockSrvr::SubClass_Events::OnRecv(CSockSrvr *lpCSockSrvr, int iClient, char *sData, int iSize)
{
	CCI[iClient].dwBytesRecv += (DWORD)iSize;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when the client / server is being started.

	Return true to start the client / server, else return false.	
*/
bool CSockSrvr::SubClass_Events::OnStart(CSockSrvr *lpCSockSrvr, int iListenPort)
{

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when the client / server is being stopped.

	Return true to start the client / server, else return false.	
*/
bool CSockSrvr::SubClass_Events::OnStop(CSockSrvr *lpCSockSrvr)
{
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
